# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import staff.person_filter.models


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='PersonsFilter',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('persons_count', models.IntegerField(default=0)),
                ('result_hash', models.CharField(max_length=40)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('updated_at', models.DateTimeField(auto_now_add=True)),
                ('filter_id', models.CharField(max_length=40, blank=True, null=True, default=None)),
                ('department', models.ForeignKey(blank=True, null=True, related_name='direct_filter', to='django_intranet_stuff.Department')),
                ('person', models.OneToOneField(blank=True, null=True, related_name='direct_filter', to='django_intranet_stuff.Staff')),
            ],
        ),
        migrations.CreateModel(
            name='PersonToPersonFilter',
            fields=[
                ('id', staff.person_filter.models.BigAutoField(primary_key=True, serialize=False)),
                ('personsfilter', models.ForeignKey(to='person_filter.PersonsFilter')),
                ('staff', models.ForeignKey(to='django_intranet_stuff.Staff')),
            ],
            options={
                'db_table': 'person_filter_personsfilter_persons',
            },
        ),
        migrations.CreateModel(
            name='SavedPersonsFilter',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('name', models.CharField(max_length=128)),
                ('is_bookmark', models.BooleanField(default=False)),
                ('is_for_cab', models.BooleanField(db_index=True, default=False)),
                ('absences_subscription', models.BooleanField(default=False)),
                ('birthdays_subscription', models.BooleanField(default=False)),
                ('person', models.ForeignKey(related_name='saved_filters', to='django_intranet_stuff.Staff')),
                ('persons_filter', models.ForeignKey(related_name='saved_filters', to='person_filter.PersonsFilter')),
            ],
        ),
        migrations.AddField(
            model_name='personsfilter',
            name='persons',
            field=models.ManyToManyField(related_name='persons_filters', to='django_intranet_stuff.Staff', through='person_filter.PersonToPersonFilter'),
        ),
        migrations.AlterUniqueTogether(
            name='savedpersonsfilter',
            unique_together=set([('person', 'persons_filter')]),
        ),
        migrations.AlterUniqueTogether(
            name='persontopersonfilter',
            unique_together=set([('personsfilter', 'staff')]),
        ),
        migrations.AlterUniqueTogether(
            name='personsfilter',
            unique_together=set([('filter_id', 'person', 'department')]),
        ),
    ]
