from staff.lib.models.mptt import filter_by_heirarchy


class BasePersonsGetter(object):

    def __init__(self, filter_context, url=None):
        self.context = filter_context
        self.url = url
        self._url_dep = None

    @property
    def url_dep(self):
        if self.url and self._url_dep is None:
            self._url_dep = self.context.get_base_dep_qs().get(url=self.url)
        return self._url_dep

    def _filter_by_url(self, qs):
        if self.url:
            qs = filter_by_heirarchy(
                qs,
                mptt_objects=[self.url_dep],
                by_children=True,
                include_self=True,
                filter_prefix='department__',
            )
        return qs


class FlatPersonsGetter(BasePersonsGetter):

    DEFAULT_LIMIT = 100

    def __init__(self, filter_context, url=None, page=1, limit=None):
        self.page = page
        self.limit = limit or self.DEFAULT_LIMIT
        super(FlatPersonsGetter, self).__init__(filter_context, url)

    def _get_filtered_qs(self):
        persons_qs = self.context.get_person_qs()
        persons_qs = self._filter_by_url(persons_qs)
        return persons_qs

    def get_flat_persons(self):
        qs = self._get_filtered_qs()
        left_bound = (self.page - 1) * self.limit
        right_bound = left_bound + self.limit
        return list(qs[left_bound:right_bound])

    def count(self):
        qs = self._get_filtered_qs()
        return qs.count()
