from django.conf.urls import url

from staff.person_filter import views

urlpatterns = [
    url(r'^saved-filters/?$', views.saved_filters_list, name='saved-filters-list'),
    url(r'^saved-filters/create/?$', views.saved_filter_create, name='saved-filter-create'),
    url(r'^saved-filters/(?P<saved_filter_id>\d+)/?$', views.saved_filter, name='saved-filter'),
    url(r'^saved-filters/(?P<saved_filter_id>\d+)/persons/?$', views.saved_filter_persons, name='saved-filter-persons'),
    url(r'^subscribers/?$', views.subscribers, name='subscribers'),

    url(r'^filter/?$', views.meta, name='meta'),
    url(r'^filter/create/?$', views.create_filter, name='create'),
    url(r'^filter/replace/?$', views.replace_filter, name='replace'),
    url(r'^filter/persons/?$', views.filter_persons, name='persons'),
    url(r'^filter/(?P<filter_id>\w+)/?$', views.get_filter, name='get-filter'),
]
