from staff.person_profile.permissions.base import Block, BaseRegistry
from staff.person_profile.permissions.check_permissions import can_view_phones
from staff.person_profile.constants import TARGET_TYPES


class CardsBlockRegistry(BaseRegistry):

    # login, staff_url, work_email, custom_work_email
    base_fields = Block(
        show_on=(
            TARGET_TYPES.employee,
            TARGET_TYPES.robot,
            TARGET_TYPES.agreed_dismissed,
            TARGET_TYPES.dismissed,
        ),
        external_owner=True,
        external_other=True,
    )

    # avatar
    avatar = Block(
        show_on=(
            TARGET_TYPES.employee,
            TARGET_TYPES.robot,
            TARGET_TYPES.agreed_dismissed,
            TARGET_TYPES.dismissed,
        ),
        external_owner=True,
        external_other=True,
    )

    # first_name, last_name
    names = Block(
        show_on=(
            TARGET_TYPES.employee,
            TARGET_TYPES.robot,
            TARGET_TYPES.agreed_dismissed,
        ),
        external_owner=True,
        external_other=True,
    )

    # phones: mobile/work
    phones = Block(
        show_on=(
            TARGET_TYPES.employee,
            TARGET_TYPES.robot,
            TARGET_TYPES.agreed_dismissed,
            TARGET_TYPES.dismissed,
        ),
        external_owner=True,
        custom_rule=can_view_phones,
    )

    # gender
    personal = Block(
        show_on=(
            TARGET_TYPES.employee,
            TARGET_TYPES.agreed_dismissed,
            TARGET_TYPES.dismissed,
        ),
        external_owner=True,
    )

    # office_id, office
    location_office = Block(
        show_on=(
            TARGET_TYPES.employee,
            TARGET_TYPES.robot,
            TARGET_TYPES.agreed_dismissed,
            TARGET_TYPES.dismissed,
        ),
        external_owner=True,
    )

    # room_id, room
    location_room = Block(show_on=(TARGET_TYPES.employee,))

    # table: id/url
    location_table = Block(show_on=(TARGET_TYPES.employee,))

    # work_mode
    work_mode = Block(show_on=(TARGET_TYPES.employee,))

    # dep: name/bg_color/fg_color
    department = Block(
        show_on=(
            TARGET_TYPES.employee,
            TARGET_TYPES.robot,
            TARGET_TYPES.agreed_dismissed,
            TARGET_TYPES.dismissed,
        ),
    )

    # jabber_status, last_office: office/ago
    last_office = Block(
        show_on=(
            TARGET_TYPES.employee,
            TARGET_TYPES.agreed_dismissed,
            TARGET_TYPES.dismissed,
        ),
        external_owner=True,
    )

    # gap url/color/name/type
    gap = Block(show_on=(TARGET_TYPES.employee,))

    # position, is_memorial, is_dismissed, is_homie
    position = Block(
        show_on=(
            TARGET_TYPES.employee,
            TARGET_TYPES.robot,
            TARGET_TYPES.agreed_dismissed,
            TARGET_TYPES.dismissed,
        ),
    )

    # accounts: Вики, Этушка, Встречи
    accounts = Block(
        show_on=(
            TARGET_TYPES.employee,
            TARGET_TYPES.agreed_dismissed,
            TARGET_TYPES.dismissed,
        ),
    )
