from typing import Any, Dict


class AbstractBlock(object):
    fields = set()
    name: str = None

    def __init__(self, data, cache):
        self.data = data
        self.cache = cache

    def get_raw_data(self) -> Dict[str, Any]:
        return {k: self.data[k] for k in self.fields if not k.endswith('_en')}

    def get_data(self) -> Dict[str, Any]:
        return self.get_raw_data()
