from typing import Iterable, Optional

from staff.departments.models import DepartmentRoles
from staff.lib.utils.qs_values import localize, extract_related

from staff.person_profile.controllers.blocks.abstract_dep_chain_block import AbstractDepChainBlock


class ChiefBlock(AbstractDepChainBlock):
    fields = AbstractDepChainBlock.fields | {'id'}
    department_roles: Optional[Iterable[str]] = (DepartmentRoles.CHIEF.value, )
    name: str = 'chief'

    def find_chief(self, roles_chain):
        person_login = self.data['login']

        for roles in roles_chain:
            chiefs = [
                extract_related(role, 'staff', pop=False)
                for role in roles
                if role['role_id'] in self.department_roles
            ]
            chiefs_logins = [p['login'] for p in chiefs]
            if person_login in chiefs_logins:
                chiefs = chiefs[chiefs_logins.index(person_login) + 1:]
            if chiefs:
                return chiefs[0]

        return None

    def get_data(self):
        roles_chain = self.get_roles_chain()
        chief = self.find_chief(roles_chain)

        if chief:
            return {self.name: localize(chief)}
        else:
            return {}
