from staff.lib.utils.qs_values import extract_related
from staff.person_profile.controllers.blocks.abstract_block import AbstractBlock


class CityBlock(AbstractBlock):
    name = 'location_office'

    fields = {
        'office__city__name',
        'office__city__name_en',
        'office__city__id',
    }

    def get_data(self):
        city = extract_related(self.data, 'office__city', pop=False)
        return {
            'city_id': city['id'],
            'city_name': city['name'],
        }
