from staff.lib.utils.qs_values import localize, extract_related

from staff.departments.models import DepartmentStaff, DepartmentRoles

from staff.person_profile.controllers.blocks.abstract_block import AbstractBlock


class CuratorsBlock(AbstractBlock):
    name = 'curators'
    fields = 'id',

    def get_data(self):
        curators = list(
            DepartmentStaff.objects
            .filter(
                role_id__in=[DepartmentRoles.CURATOR_EXPERIMENT.value, DepartmentRoles.CURATOR_BU.value],
                department__in=(
                    DepartmentStaff.objects
                    .filter(staff_id=self.data['id'], role_id=DepartmentRoles.CHIEF.value)
                    .values('department')
                )
            )
            .values(
                'department__url',
                'department__name',
                'department__name_en',
                'staff__login',
                'staff__first_name',
                'staff__first_name_en',
                'staff__last_name',
                'staff__last_name_en',
                'role',
            )
        )

        for curator in curators:
            localize(curator)
            curator['department'] = extract_related(curator, 'department')
            curator['curator'] = extract_related(curator, 'staff')

        return {'curators': curators}
