from staff.person_profile.controllers.blocks.abstract_block import AbstractBlock


class DismissedBlock(AbstractBlock):
    name = 'quit_at'

    fields = {
        'quit_at',
        'is_dismissed',
    }


class ShortDismissedBlock(DismissedBlock):
    name = 'quit_at_short'

    def get_data(self):
        res = {'is_dismissed': self.data['is_dismissed']}
        quit_at = self.data['quit_at']
        if not quit_at:
            return res
        res['quit_info'] = {
            'year': quit_at.year,
            'month': quit_at.month,
        }
        return res
