from staff.person.models import EDU_STATUS, EDU_DIRECTION
from staff.person_profile.controllers.blocks.abstract_block import AbstractBlock
from staff.person_profile.controllers.blocks.utils import choices_key_get


class EduBlock(AbstractBlock):
    name = 'education'

    fields = {
        'edu_place',
        'edu_place_en',
        'edu_status',
        'edu_direction',
        'edu_date',
    }

    def get_data(self):
        data = self.get_raw_data()
        data['edu_status'] = choices_key_get(EDU_STATUS, data['edu_status'], '')
        data['edu_direction'] = choices_key_get(
            EDU_DIRECTION, data['edu_direction'], '')
        return data
