from typing import Iterable, Optional

from staff.departments.models import DepartmentRoles
from staff.lib.utils.qs_values import localize, extract_related

from staff.person_profile.controllers.blocks.abstract_dep_chain_block import AbstractDepChainBlock


class HRPartnerBlock(AbstractDepChainBlock):
    name = 'hr_partners'
    department_roles: Optional[Iterable[str]] = (DepartmentRoles.HR_PARTNER.value,)

    def get_data(self):
        roles_chain = self.get_roles_chain()
        hr_partners = []

        for roles in roles_chain:
            for role in roles:
                if role['role_id'] in self.department_roles:
                    hr_partners.append(localize(extract_related(role, 'staff', pop=False)))

            if hr_partners:
                break

        return {'hr_partners': hr_partners}
