from staff.lib.utils.qs_values import extract_related
from staff.person_profile.controllers.blocks.abstract_block import AbstractBlock


class LocationOfficeBlock(AbstractBlock):
    name = 'location_office'

    fields = {
        'office__id',
        'office__name',
        'office__name_en',
        'office__code',
        'office__have_map',
    }

    def get_data(self):
        office = extract_related(self.data, 'office', pop=False)
        return {
            'office_id': office['id'],
            'office_name': office['name'],
            'office_code': office['code'],
            'office_have_map': office['have_map'],
        }
