from staff.lib.utils.qs_values import extract_related
from staff.person_profile.controllers.blocks.abstract_block import AbstractBlock


class LocationRoomBlock(AbstractBlock):
    name = 'location_room'

    fields = {
        'room__id',
        'room__name',
        'room__name_en',
        'room__num',
    }

    def get_data(self):
        room = extract_related(self.data, 'room')
        return {
            'room_id': room['id'],
            'room_name': room['name'],
            'room_num': room['num'],
        }
