from staff.lib.utils.qs_values import extract_related
from staff.person_profile.controllers.blocks.abstract_block import AbstractBlock


class LocationTableBlock(AbstractBlock):
    name = 'location_table'

    fields = {
        'table__id',
        'table__floor__id',
        'table__floor__name',
        'table__floor__name_en',
        'location_descr',
        'location_descr_en',
    }

    def get_data(self):
        table = extract_related(self.data, 'table')
        return {
            'how_to_find': self.data['location_descr'],
            'floor_name': table['floor__name'],
            'table_id': table['id'],
            'floor_id': table['floor__id'],
        }
