from staff.lib.utils.qs_values import extract_related
from staff.person_profile.controllers.blocks.abstract_block import AbstractBlock


class MemorialBlock(AbstractBlock):
    name = 'memorial_info'

    fields = {
        'memorial_profile__status_block_html',
        'memorial_profile__status_block_html_en',
        'memorial_profile__death_date',
    }

    def get_data(self):
        memorial = extract_related(self.data, 'memorial_profile', pop=False)
        memorial['memorial_text'] = memorial.pop('status_block_html')
        return memorial
