from staff.person_profile.controllers.blocks.abstract_block import AbstractBlock
from staff.person_profile.controllers.blocks.utils import replace_middle_name


class NameBlock(AbstractBlock):
    name = 'fio'
    fields = {
        'first_name',
        'last_name',
        'middle_name',
        'preferred_name',
        'first_name_en',
        'last_name_en',
        'preferred_name_en',
    }

    def get_data(self):
        data = self.get_raw_data()
        replace_middle_name(data)
        return data
