from staff.lib.utils.qs_values import extract_related

from staff.person_profile.controllers.blocks.abstract_block import AbstractBlock


class OccupationBlock(AbstractBlock):
    name = 'occupation'

    fields = {
        'extra__occupation__name',
        'extra__occupation__description',
        'extra__occupation__description_en',
        'extra__occupation__code',
    }

    def get_data(self):
        extra = extract_related(extract_related(self.data, 'extra'), 'occupation')
        return {'occupation': extra}
