from staff.lib import waffle

from django.conf import settings

from staff.person.models import EMPLOYMENT
from staff.person_profile.controllers.blocks.abstract_block import AbstractBlock
from staff.person_profile.controllers.blocks.utils import choices_key_get


class OfficialOrganizationBlock(AbstractBlock):
    name = 'official_organization'

    fields = {
        'organization__id',
        'organization__name',
        'organization__name_en',
        'employment',
    }

    def get_data(self):
        data = self.get_raw_data()

        org_id = data.pop('organization__id')
        organization_name = data.pop('organization__name')
        if org_id != settings.ROBOTS_ORGANIZATION_ID:
            data['organization_name'] = organization_name

        if data['employment'] and waffle.switch_is_active('enable_profile_employment'):
            data['employment'] = choices_key_get(EMPLOYMENT, data['employment'])
        else:
            del data['employment']

        return data
