from datetime import datetime

from staff.person_profile.controllers.blocks.abstract_block import AbstractBlock


class PasswordBlock(AbstractBlock):
    name = 'password'

    fields = {
        'ad_information__password_expires_at',
    }

    def get_data(self):
        if self.data['ad_information__password_expires_at']:
            now = datetime.now()
            password_expires_at = self.data['ad_information__password_expires_at']
            return {
                'password_expired_at': password_expires_at,
                'password_days_reminder': (password_expires_at - now).days,
            }

        return {}
