from staff.person.models import GENDER, FAMILY_STATUS, TSHIRT_SIZE
from staff.person_profile.controllers.blocks.abstract_block import AbstractBlock
from staff.person_profile.controllers.blocks.utils import choices_key_get


class PersonalBlock(AbstractBlock):
    name = 'personal'

    fields = {
        'gender',
        'family_status',
        'tshirt_size',
        'children',
        'about',
        'address',
        'address_en',
        'mobile_phone_model',
        'department__id',
    }

    def get_data(self):
        data = self.get_raw_data()

        data['gender'] = choices_key_get(GENDER, data['gender'])
        data['family_status'] = choices_key_get(
            FAMILY_STATUS, data['family_status'], '')
        data['tshirt_size'] = choices_key_get(TSHIRT_SIZE, data['tshirt_size'])

        if data['children'] is None:
            del data['children']

        return data
