from staff.person.models import AFFILIATION
from staff.person_profile.controllers.blocks.abstract_block import AbstractBlock
from staff.person_profile.controllers.blocks.utils import choices_key_get


class PropertiesBlock(AbstractBlock):
    fields = {
        'id',
        'login',
        'is_dismissed',
        'is_robot',
        'affiliation',
    }

    def get_data(self):
        data = self.get_raw_data()
        data['affiliation'] = choices_key_get(AFFILIATION, data['affiliation'])
        return data
