from typing import Tuple

from django.utils.translation import get_language


def choices_key_get(choices, db_value, default=None):
    if not db_value:
        return default

    try:
        return choices.get_name(db_value)
    except KeyError:
        return default


def replace_middle_name(data):
    if get_language() != 'ru':
        del data['middle_name']


def get_person_fields() -> Tuple[str]:
    fields = ['login', 'id', 'first_name', 'last_name', 'middle_name', 'first_name_en', 'last_name_en']
    if get_language() == 'ru':
        fields.append('middle_name')
    return tuple(fields)
