import math

from staff.person_profile.controllers.blocks.abstract_block import AbstractBlock


class VacationBlock(AbstractBlock):
    name = 'vacation'

    fields = {
        'vacation',
        'extra_vacation',
    }

    def get_data(self):
        result = {}
        if self.data['vacation'] is not None:
            result['vacation'] = math.floor(self.data['vacation'])
        if self.data['extra_vacation'] is not None:
            result['extra_vacation'] = math.floor(self.data['extra_vacation'])
        return result
