from typing import Optional, Iterable

from staff.departments.models import ValuestreamRoles
from staff.lib.models.roles_chain import DepDataType

from staff.person_profile.controllers.blocks.chief_block import ChiefBlock
from staff.person_profile.controllers.blocks.value_stream_block import ValueStreamBlock


class ValueStreamChiefBlock(ChiefBlock):
    fields = {'id', 'login'}
    department_roles: Optional[Iterable[str]] = (ValuestreamRoles.HEAD.value,)
    name: str = 'value_stream_chief'

    def get_dep_data(self) -> DepDataType:
        return ValueStreamBlock(self.data, self.cache).get_dep_data()
