from staff.lib.exceptions import ErrorWithStatusCode

from staff.person.models import Staff
from staff.person.controllers import PersonCtl
from staff.person_profile.errors import log_does_not_exist_staff_login

import logging
logger = logging.getLogger('person_profile.controllers.head')


class HeadError(ErrorWithStatusCode):
    pass


def get_initial(login):
    with log_does_not_exist_staff_login(logger=logger, message_params=[login], raise_e=HeadError):
        return (
            Staff.objects
            .values(
                'first_name',
                'middle_name',
                'last_name',
                'position',
                'preferred_name',
                'first_name_en',
                'last_name_en',
                'position_en',
                'preferred_name_en',
            ).get(login=login)
        )


def update(login, data, request_user):
    with log_does_not_exist_staff_login(logger=logger, message_params=[login], raise_e=HeadError):
        person = Staff.objects.get(login=login)

    PersonCtl(person).update(
        {
            'first_name': data.get('first_name', ''),
            'middle_name': data.get('middle_name', ''),
            'last_name': data.get('last_name', ''),
            'position': data.get('position', ''),
            'first_name_en': data.get('first_name_en', ''),
            'last_name_en': data.get('last_name_en', ''),
            'position_en': data.get('position_en', ''),
            'preferred_name': data.get('preferred_name', ''),
            'preferred_name_en': data.get('preferred_name_en', ''),
        }
    ).save(request_user)
