from staff.lib.exceptions import ErrorWithStatusCode

from staff.person.models import Staff

from staff.person.controllers import PersonCtl
from staff.person_profile.errors import log_does_not_exist_staff_login

import logging
logger = logging.getLogger('person_profile.controllers.official')


class OfficialError(ErrorWithStatusCode):
    pass


def get_initial(login):
    with log_does_not_exist_staff_login(logger=logger, message_params=[login], raise_e=OfficialError):
        return (
            Staff.objects
            .values(
                'employment',
                'organization_id',
            ).get(login=login)
        )


def update(login, data, request_user):
    try:
        ctl = PersonCtl(Staff.objects.get(login=login))
        ctl.organization = data['organization_id']  # здесь Organization object
        ctl.employment = data['employment']
        ctl.save(request_user)
    except Exception as e:
        raise OfficialError(e)
