from staff.lib.exceptions import ErrorWithStatusCode

from staff.person.models import Staff

from staff.person.controllers import PersonCtl
from staff.person_profile.errors import log_does_not_exist_staff_login

import logging
logger = logging.getLogger('person_profile.controllers.other')


class OtherError(ErrorWithStatusCode):
    pass


def get_initial(login):
    with log_does_not_exist_staff_login(logger=logger, message_params=[login], raise_e=OtherError):
        return (
            Staff.objects
            .values(
                'about',
                'gender',
                'birthday',
                'edu_status',
                'edu_direction',
                'edu_place',
                'edu_place_en',
                'edu_date',
                'address',
                'address_en',
                'family_status',
                'children',
                'tshirt_size',
                'mobile_phone_model')
            .get(login=login)
        )


def update(login, data, request_user):
    with log_does_not_exist_staff_login(logger=logger, message_params=[login], raise_e=OtherError):
        person = Staff.objects.get(login=login)

    try:
        PersonCtl(
            person
        ).update(
            {
                'about': data.get('about', ''),
                'gender': data['gender'],
                'birthday': data.get('birthday'),
                'edu_status': data.get('edu_status', ''),
                'edu_direction': data.get('edu_direction', ''),
                'edu_place': data.get('edu_place', ''),
                'edu_place_en': data.get('edu_place_en', ''),
                'edu_date': data.get('edu_date'),
                'address': data.get('address', ''),
                'address_en': data.get('address_en', ''),
                'family_status': data.get('family_status', ''),
                'children': data.get('children'),
                'tshirt_size': data.get('tshirt_size', ''),
                'mobile_phone_model': data.get('mobile_phone_model', ''),
            }
        ).save(request_user)
    except Exception as e:
        raise OtherError(e)
