from staff.lib.exceptions import ErrorWithStatusCode
from staff.person.models import Staff

from staff.user_settings.objects import PersonSettings
from staff.person.controllers import PersonCtl
from staff.person_profile.errors import log_does_not_exist_staff_login

import logging
logger = logging.getLogger('person_profile.controllers.settings_other')


class SettingsOtherError(ErrorWithStatusCode):
    pass


def get_initial(login):
    with log_does_not_exist_staff_login(logger=logger, message_params=[login], raise_e=SettingsOtherError):
        result = Staff.objects.values(
            'id',
            'tz',
            'auto_translate',
            'lang_ui',
            'domain',
            'shell',
            'show_all_middle_name',
            'show_beta_interface',
        ).get(login=login)

    result.update(dict(PersonSettings(result.pop('id'))))

    return result


def update(login, data, request_user):
    with log_does_not_exist_staff_login(logger=logger, message_params=[login], raise_e=SettingsOtherError):
        person = Staff.objects.get(login=login)

    _data = data.copy()

    try:
        PersonCtl(person).update({
            'tz': _data.pop('tz', ''),
            'auto_translate': _data.pop('auto_translate', False),
            'lang_ui': _data.pop('lang_ui', ''),
            'domain': _data.pop('domain', ''),
            'shell': _data.pop('shell', ''),
            'show_all_middle_name': _data.pop('show_all_middle_name', False),
            'show_beta_interface': _data.pop('show_beta_interface', False),
        }).save(request_user)
    except Exception as e:
        raise SettingsOtherError(e)

    try:
        PersonSettings(person.id).commit(_data)
    except Exception as e:
        raise SettingsOtherError(e)
