import json

from django.views.decorators.http import require_POST

from staff.lib.decorators import (
    responding_json,
    use_request_lang,
    available_for_external,
)
from staff.lib.forms.staff_form_grid import StaffFormGrid

from ..controllers import redirection as ctl
from ..forms.redirection import RedirectionForm
from staff.lib.forms.errors import (
    invalid_json_error,
    default_error,
)
from ..permissions.utils import observer_has_perm

import logging
logger = logging.getLogger('person_profile.edit_views.edit_redirections_view')

FORM_NAME = 'redirections'


@responding_json
@available_for_external
@require_POST
@observer_has_perm('edit_settings')
@use_request_lang
def edit_redirections(request, login):
    try:
        form_data = json.loads(request.body).get(FORM_NAME, [])
    except ValueError:
        logger.exception('Wrong JSON: %s', request.body)
        return invalid_json_error(request.body), 400

    grid = StaffFormGrid(RedirectionForm, data=form_data)

    if not grid.is_valid():
        return {'errors': {FORM_NAME: grid.errors()}}

    try:
        ctl.clean(login, [v['id'] for v in grid.cleaned_data])
    except ctl.RedirectionError:
        return default_error(), 500

    return {'target': {}}
