from django.views.decorators.http import require_GET
from django.views.decorators.csrf import ensure_csrf_cookie

from staff.lib.decorators import (
    responding_json,
    use_request_lang,
    available_for_external,
)
from staff.lib.forms.staff_form_grid import StaffFormGrid

from ..controllers import (
    settings_other as settings_other_ctl,
    redirection as redirection_ctl,
)
from ..forms import (
    redirection as redirection_form,
    settings_other as settings_other_form,
)
from ..permissions.utils import observer_has_perm

import logging
logger = logging.getLogger('person_profile.edit_views.edit_settings_meta_view')


@ensure_csrf_cookie
@responding_json
@available_for_external
@require_GET
@observer_has_perm('edit_settings')
@use_request_lang
def edit_settings_meta(request, login):
    # redirections
    result = {
        'redirections': (
            StaffFormGrid(
                redirection_form.RedirectionForm,
                initial=redirection_ctl.get_initial(login)
            )
            .as_front_dict()
        )
    }

    # settings_other
    s_grid = (
        StaffFormGrid(
            settings_other_form.SettingsOtherForm,
            initial=[settings_other_ctl.get_initial(login)]
        )
    )
    result['settings_other'] = s_grid.as_front_dict()
    result['choices'] = s_grid.choices_as_front_dict()

    return result
