from functools import partial

from staff.person.models import Staff

from staff.lib.forms.errors import LogException

log_does_not_exist_staff_login = partial(
    LogException,
    catch_e=Staff.DoesNotExist,
    message='Cannot find person by login: %s',
    status_code=404,
)

log_does_not_exist_staff_id = partial(
    LogException,
    catch_e=Staff.DoesNotExist,
    message='Cannot find person by ID: %s',
    status_code=404,
)
