from staff.lib.forms.staff_form import StaffForm
from staff.lib.forms.staff_fields import StaffCharField
from staff.lib.forms.validators import latin_field_validator

from staff.innerhire.models import CANDIDATE_INFO_MAX_LEN


class DutyForm(StaffForm):
    strip_fields = ['duties', 'duties_en', 'candidate_info']

    duties = StaffCharField(required=False, max_length=1024)
    duties_en = StaffCharField(
        required=False,
        max_length=1024,
        validators=[latin_field_validator],
    )
    candidate_info = StaffCharField(
        required=False,
        max_length=CANDIDATE_INFO_MAX_LEN
    )
