from staff.lib.forms.staff_form import StaffForm
from staff.lib.forms.staff_fields import StaffCharField
from staff.lib.forms.validators import (
    latin_field_validator,
    empty_field_validator,
    name_validator,
    name_en_validator,
    middle_name_validator,
)


class HeadForm(StaffForm):
    strip_fields = ['first_name', 'middle_name', 'last_name', 'preferred_name', 'position',
                    'first_name_en', 'last_name_en', 'preferred_name_en', 'position_en']
    first_upper_fields = ['first_name', 'middle_name', 'last_name',
                          'first_name_en', 'last_name_en']

    first_name = StaffCharField(
        max_length=50,
        validators=[empty_field_validator, name_validator]
    )
    middle_name = StaffCharField(
        required=False,
        max_length=50,
        validators=[middle_name_validator]
    )
    last_name = StaffCharField(
        max_length=100,
        validators=[empty_field_validator, name_validator]
    )
    preferred_name = StaffCharField(
        max_length=50,
        required=False,
    )
    position = StaffCharField(
        max_length=150,
        validators=[empty_field_validator],
    )
    first_name_en = StaffCharField(
        max_length=50,
        validators=[empty_field_validator, name_en_validator]
    )
    last_name_en = StaffCharField(
        max_length=100,
        validators=[empty_field_validator, name_en_validator]
    )
    position_en = StaffCharField(
        max_length=150,
        validators=[empty_field_validator, latin_field_validator]
    )
    preferred_name_en = StaffCharField(
        max_length=50,
        required=False,
    )

    def clean(self):
        super(HeadForm, self).clean()
        self._first_upper_fields()
        return self.cleaned_data

    def _first_upper_fields(self):
        for field in self.first_upper_fields:
            value = self.cleaned_data.get(field)
            if value and isinstance(value, str):
                self.cleaned_data[field] = value[0].upper() + value[1:]
