from staff.person.models import Organization, EMPLOYMENT

from staff.lib.forms.staff_form import StaffForm
from staff.lib.forms.staff_fields import (
    StaffChoiceField,
    StaffLocalizedModelChoiceField,
)


class OfficialForm(StaffForm):
    employment = StaffChoiceField(
        choices_source=EMPLOYMENT
    )

    organization_id = StaffLocalizedModelChoiceField(
        queryset=Organization.objects.filter(intranet_status=1),
        empty_label=None,
        to_field_name='id',
    )
