from datetime import date

from django.forms import ValidationError

from staff.person.models import (
    GENDER,
    EDU_STATUS,
    EDU_DIRECTION,
    FAMILY_STATUS,
    TSHIRT_SIZE,
)

from staff.lib.forms.staff_form import StaffForm
from staff.lib.forms.staff_fields import (
    StaffChoiceField,
    StaffCharField,
    StaffDateField,
    StaffIntegerField,
)
from staff.lib.forms.validators import latin_field_validator


class OtherForm(StaffForm):
    strip_fields = [
        'about',
        'edu_place',
        'edu_place_en',
        'address',
        'address_en',
        'mobile_phone_model',
    ]

    about = StaffCharField(
        required=False,
        max_length=1024
    )

    gender = StaffChoiceField(
        choices_source=GENDER
    )

    birthday = StaffDateField(
        required=False
    )

    edu_status = StaffChoiceField(
        required=False,
        choices_source=EDU_STATUS,
        empty_label='—',
    )

    edu_direction = StaffChoiceField(
        required=False,
        choices_source=EDU_DIRECTION,
        empty_label='—',
    )

    edu_place = StaffCharField(
        required=False,
        max_length=255
    )

    edu_place_en = StaffCharField(
        required=False,
        max_length=255,
        validators=[latin_field_validator]
    )

    edu_date = StaffDateField(
        required=False
    )

    address = StaffCharField(
        required=False,
        max_length=255
    )

    address_en = StaffCharField(
        required=False,
        max_length=255,
        validators=[latin_field_validator]
    )

    family_status = StaffChoiceField(
        required=False,
        choices_source=FAMILY_STATUS,
        empty_label='—',
    )

    children = StaffIntegerField(
        required=False,
        min_value=0,
        max_value=69,
    )

    tshirt_size = StaffChoiceField(
        required=False,
        choices_source=TSHIRT_SIZE,
        empty_label='—',
    )

    mobile_phone_model = StaffCharField(
        required=False,
        max_length=100
    )

    def clean_birthday(self):
        birthday = self.cleaned_data['birthday']
        if birthday and birthday < date(1900, 1, 1):
            raise ValidationError(
                '{"error_key": "default-field-invalid"}',
                code='invalid',
            )
        return birthday

    def clean_edu_date(self):
        edu_date = self.cleaned_data['edu_date']
        if edu_date and edu_date < date(1900, 1, 1):
            raise ValidationError(
                '{"error_key": "default-field-invalid"}',
                code='invalid',
            )
        return edu_date
