import pytz

from django.conf import settings
from django.core.validators import RegexValidator
from django.forms import ValidationError

from staff.person.models import DOMAIN

from staff.lib.forms.staff_form import StaffForm
from staff.lib.forms.staff_fields import (
    StaffChoiceField,
    StaffCharField,
    StaffBooleanField,
)


TZ_CHOICES = [(tz, tz) for tz in pytz.common_timezones]


class SettingsOtherForm(StaffForm):
    strip_fields = ['tz', 'lang_ui', 'domain', 'shell']

    tz = StaffChoiceField(choices=TZ_CHOICES)
    auto_translate = StaffBooleanField(required=False)
    lang_ui = StaffChoiceField(choices=settings.LANGUAGES)
    domain = StaffChoiceField(choices_source=DOMAIN)
    shell = StaffCharField(
        max_length=50,
        validators=[RegexValidator(r'^/[a-z/]+[^/]$')],
    )
    is_calendar_vertical = StaffBooleanField(required=False)
    show_all_middle_name = StaffBooleanField(required=False)
    show_beta_interface = StaffBooleanField(required=False)

    def clean_shell(self):
        value = self.cleaned_data['shell']
        if not value.strip():
            raise ValidationError(
                '{"error_key": "default-field-required"}',
                code='default-field-required')
        return value
