from itertools import groupby


def reset_all_position(model, f=None):
    entities = (
        model.objects
        .filter(intranet_status=1)
        .order_by('staff', 'id')
    )

    total = entities.count()
    print('Total to do: %s' % total)
    n = 0
    for person_id, person_entities in groupby(entities, lambda x: x.person_id):
        for position, entity in enumerate(person_entities, start=1):
            if entity.position != position:
                entity.position = position
            entity = entity if not f else f(entity)
            entity.save()
            n += 1
            if not n % 1000:
                print('%s from %s done...' % (n, total))
    print('Done.')
