from django.core.management.base import (
    BaseCommand,
    CommandError,
)
from staff.person.models import StaffPhone
from ._reset_position import reset_all_position
from ._phone_protocol_migration import migrate_phone_protocol


class Command(BaseCommand):
    help = 'Переустанавливает position у всех телефонов в StaffPhone и меняет protocol'

    def handle(self, *args, **options):
        try:
            reset_all_position(StaffPhone, f=migrate_phone_protocol)
        except Exception as e:
            raise CommandError(e)
