from django.core.management.base import BaseCommand
from django.db.models import Q
from django.conf import settings

from staff.person.models.person import WORK_MODES
from staff.users.models import Staff
from staff.person_profile.tasks import update_work_modes


class Command(BaseCommand):
    help = 'Загружает OFFICEMODE для сотрудников'

    def add_arguments(self, parser):
        parser.add_argument('count_days', nargs='?')
        parser.add_argument('--update-all-users', action='store_true', dest='update-all-users', default=False)

    def handle(self, *args, **options):
        count_days = options.get('count_days', None)
        update_all_users = options.get('update-all-users', False)

        update_work_modes(count_days)

        if update_all_users:
            query = Q(work_mode=None, is_dismissed=False, is_robot=False)
            count_empty_work_mode = Staff.objects.filter(query).count()

            homeworker_query = query & (Q(is_homeworker=True) | Q(office_id=settings.HOMIE_OFFICE_ID))
            Staff.objects.filter(homeworker_query).update(work_mode=WORK_MODES.REMOTE)

            Staff.objects.filter(query).update(work_mode=WORK_MODES.OFFICE)

            self.stdout.write(f"Profiles updated with empty work_mode: {count_empty_work_mode}\n")
        self.stdout.write("Done\n")
