from django.conf.urls import url

from staff.person_profile import views, edit_views, bulk_views

urlpatterns = [
    url(
        r'^meta/(?P<login>~?[^\/]*)?/?$',
        views.meta_view.meta,
        name='meta',
    ),
    url(
        r'^cars/(?P<login>[\w\-\_\.]+)/?$',
        views.cars_view.cars,
        name='cars',
    ),
    url(
        r'^goals/(?P<login>[\w\-\_\.]+)/?$',
        views.goals_view.goals,
        name='goals',
    ),
    url(
        r'^bicycles/(?P<login>[\w\-\_\.]+)/?$',
        views.bicycles_view.bicycles,
        name='bicycles',
    ),
    url(
        r'^calendar/(?P<login>[\w\-\_\.]+)/?$',
        views.calendar_view.calendar,
        name='calendar',
    ),
    url(
        r'^calendar_gaps/(?P<login>[\w\-\_\.]+)/?$',
        views.calendar_view.calendar_gaps,
        name='calendar_gaps',
    ),
    url(
        r'^calendar_holidays/(?P<login>[\w\-\_\.]+)/?$',
        views.calendar_view.calendar_holidays,
        name='calendar_holidays',
    ),
    url(
        r'^contacts/(?P<login>[\w\-\_\.]+)/?$',
        views.contacts_view.contacts,
        name='contacts',
    ),
    url(
        r'^documents/(?P<login>[\w\-\_\.]+)/?$',
        views.documents.get,
        name='documents',
    ),
    url(
        r'^documents/(?P<login>[\w\-\_\.]+)/edit/?$',
        views.documents.edit,
        name='documents_edit',
    ),
    url(
        r'^photos/(?P<login>[\w\-\_\.]+)/?$',
        views.photos_view.photos,
        name='photos',
    ),
    url(
        r'^candidate-info/(?P<login>[\w\-\_\.]+)/?$',
        views.candidate_info_view.candidate_info,
        name='candidate_info',
    ),
    url(
        r'^achievements/(?P<login>[\w\-\_\.]+)/?$',
        views.achievements_view.achievements,
        name='achievements',
    ),
    url(
        r'^services/(?P<login>[\w\-\_\.]+)/?$',
        views.services_view.services,
        name='services',
    ),
    url(
        r'^hardware/(?P<login>[\w\-\_\.]+)/?$',
        views.ware_view.hardware,
        name='hardware',
    ),
    url(
        r'^software/(?P<login>[\w\-\_\.]+)/?$',
        views.ware_view.software,
        name='software',
    ),
    url(
        r'^edoc/(?P<login>[\w\-\_\.]+)/?$',
        views.edoc_view.edoc,
        name='edoc',
    ),
    url(
        r'^food_report/(?P<login>[\w\-\_\.]+)/?$',
        views.edoc_view.full_food_report,
        name='full_food_report',
    ),
    url(
        r'^phones/(?P<login>[\w\-\_\.]+)/?$',
        views.phones_view.phones,
        name='phones',
    ),
    url(
        r'^digital_sign/(?P<login>[\w\-\_\.]+)/?$',
        views.digital_sign.get,
        name='digital_sign',
    ),
    url(
        r'^digital_sign/(?P<login>[\w\-\_\.]+)/attach-phone/?$',
        views.digital_sign.attach_phone,
        name='digital_sign_attach_phone',
    ),
    url(
        r'^digital_sign/(?P<login>[\w\-\_\.]+)/verify-code/?$',
        views.digital_sign.verify_code,
        name='digital_sign_verify_code',
    ),
    url(
        r'^digital_sign_status/(?P<login>[\w\-\_\.]+)/?$',
        views.digital_sign.get_status,
        name='digital_sign_status',
    ),
    url(
        r'^digital_sign_certification_status/(?P<login>[\w\-\_\.]+)/?$',
        views.digital_sign.get_certification_status,
        name='digital_sign_certification_status',
    ),
    url(
        r'^approvements/(?P<login>[\w\-\_\.]+)/?$',
        views.approvements_view.approvements_count,
        name='approvements',
    ),
    url(
        r'^gap_newhire_counts/?$',
        views.approvements_view.gap_newhire_counts,
        name='gap_newhire_counts',
    ),
    url(
        r'^responsible_for_robot/(?P<login>[\w\-\_\.]+)/?$',
        views.responsible_for_robot_view.responsible_for_robot,
        name='responsible_for_robot',
    ),
    url(
        r'^last_activity/(?P<login>[\w\-\_\.]+)/?$',
        views.activity_view.last_activity,
        name='last_activity',
    ),
    url(
        r'^ssh-keys/(?P<login>[\w\-\_\.]+)/?$',
        views.ssh_keys_view.ssh_keys,
        name='ssh_keys',
    ),
    url(
        r'^ssh-keys/(?P<login>[\w\-\_\.]+)/(?P<id>[\d]+)/download/?$',
        views.download_ssh_key_view.download_ssh_key,
        name='download-ssh-key',
    ),
    url(
        r'^gpg-keys/(?P<login>[\w\-\_\.]+)/?$',
        views.gpg_keys_view.gpg_keys,
        name='gpg_keys',
    ),
    url(
        r'^gpg-keys/(?P<login>[\w\-\_\.]+)/(?P<id>[\d]+)/download/?$',
        views.download_gpg_key_view.download_gpg_key,
        name='download-gpg-key',
    ),
    url(
        r'^table-books/(?P<login>[\w\-\_\.]+)/?$',
        views.table_book_view.table_books,
        name='table_books',
    ),
    url(
        r'^survey/(?P<login>[\w\-\_\.]+)/?$',
        views.survey_view.survey,
        name='survey',
    ),
    url(
        r'^departments/(?P<login>[\w\-\_\.]+)/?$',
        views.block_views.departments,
        name='departments',
    ),
    url(
        r'^value_streams/(?P<login>[\w\-\_\.]+)/?$',
        views.block_views.value_streams,
        name='value_streams',
    ),
    url(
        r'^umbrellas/(?P<login>[\w\-\_\.]+)/?$',
        views.block_views.umbrellas,
        name='umbrellas',
    ),
    url(
        r'^chief/(?P<login>[\w\-\_\.]+)/?$',
        views.block_views.chief,
        name='chief',
    ),
    url(
        r'^value_stream_chief/(?P<login>[\w\-\_\.]+)/?$',
        views.block_views.value_stream_chief,
        name='value_stream_chief',
    ),
    url(
        r'^hr_partners/(?P<login>[\w\-\_\.]+)/?$',
        views.block_views.hr_partners,
        name='hr_partners',
    ),
    url(
        r'^curators/(?P<login>[\w\-\_\.]+)/?$',
        views.block_views.curators,
        name='curators',
    ),
    url(
        r'^is_calendar_vertical/(?P<login>[\w\-\_\.]+)/?$',
        views.is_calendar_vertical.view,
        name='is_calendar_vertical',
    ),
    url(
        r'^ext_passport_view/(?P<login>[\w\-\_\.]+)/?$',
        views.ext_passport_view.ext_passport,
        name='ext_passport_view',
    ),
    url(
        r'^occupation/(?P<login>[\w\-\_\.]+)/?$',
        views.block_views.occupation,
        name='occupation',
    ),
    url(
        r'^deactivate_badge/(?P<login>[\w\-\_\.]+)/?$',
        views.badge_view.deactivate,
        name='deactivate_badge',
    ),
    url(
        r'^permissions/(?P<codename>[\w\-_]+)/',
        views.permission_view.permissions,
        name='permission',
    ),

    url(
        r'^slack_status/(?P<login>[\w\-\_\.]+)/?$',
        views.slack.status,
        name='slack_status',
    ),

    url(
        r'^bulk/?$',
        bulk_views.get_bulk,
        name='bulk-profiles',
    ),

    url(
        r'^cars/(?P<login>[\w\-\_\.]+)/edit/?$',
        edit_views.edit_cars_view.edit_cars,
        name='edit-cars',
    ),
    url(
        r'^bicycles/(?P<login>[\w\-\_\.]+)/edit/?$',
        edit_views.edit_bicycles_view.edit_bicycles,
        name='edit-bicycles',
    ),
    url(
        r'^duties/(?P<login>[\w\-\_\.]+)/edit/?$',
        edit_views.edit_duties_view.edit_duties,
        name='edit-duties',
    ),
    url(
        r'^head/(?P<login>[\w\-\_\.]+)/edit/?$',
        edit_views.edit_head_view.edit_head,
        name='edit-head',
    ),
    url(
        r'^location/(?P<login>[\w\-\_\.]+)/edit/?$',
        edit_views.edit_location_view.edit_location,
        name='edit-location',
    ),
    url(
        r'^contacts/(?P<login>[\w\-\_\.]+)/edit/?$',
        edit_views.edit_contacts_view.edit_contacts,
        name='edit-contacts',
    ),
    url(
        r'^phones/(?P<login>[\w\-\_\.]+)/edit/?$',
        edit_views.edit_phones_view.edit_phones,
        name='edit-phones',
    ),
    url(
        r'^other/(?P<login>[\w\-\_\.]+)/edit/?$',
        edit_views.edit_other_view.edit_other,
        name='edit-other',
    ),
    url(
        r'^department/(?P<login>[\w\-\_\.]+)/edit/?$',
        edit_views.edit_department_view.edit_department,
        name='edit-department',
    ),
    url(
        r'^official/(?P<login>[\w\-\_\.]+)/edit/?$',
        edit_views.edit_official_view.edit_official,
        name='edit-official',
    ),
    url(
        r'^upload_photo/(?P<login>[\w\-\_\.]+)/?$',
        edit_views.upload_photo_view.upload_photo,
        name='upload-photo',
    ),
    url(
        r'^delete_all_photos/(?P<login>[\w\-\_\.]+)/?$',
        edit_views.upload_photo_view.delete_all_photos,
        name='delete-all-photos',
    ),
    url(
        r'^settings-meta/(?P<login>[\w\-\_\.]+)/edit/?$',
        edit_views.edit_settings_meta_view.edit_settings_meta,
        name='edit-settings-meta',
    ),
    url(
        r'^settings-other/(?P<login>[\w\-\_\.]+)/edit/?$',
        edit_views.edit_settings_other_view.edit_settings_other,
        name='edit-settings-other',
    ),
    url(
        r'^redirections/(?P<login>[\w\-\_\.]+)/edit/?$',
        edit_views.edit_redirections_view.edit_redirections,
        name='edit-redirections',
    ),
    url(
        r'^ssh-keys/(?P<login>[\w\-\_\.]+)/edit/?$',
        edit_views.edit_ssh_keys_view.edit_ssh_keys,
        name='edit-ssh-keys',
    ),
    url(
        r'^send-verify-code/(?P<login>[\w\-\_\.]+)/?$',
        edit_views.edit_ssh_keys_view.send_verify_code,
        name='send-verify-code',
    ),
    url(
        r'^gpg-keys/(?P<login>[\w\-\_\.]+)/edit/?$',
        edit_views.edit_gpg_keys_view.edit_gpg_keys,
        name='edit-gpg-keys',
    ),

    # Карточки
    url(
        r'^api/staff_cards/?$',
        views.cards.staff_cards.staff_cards,
        name='staff_cards',
    ),
    url(
        r'^user_cards/?$',
        views.cards.user_cards.user_cards,
        name='user_cards',
    ),
]
