from django.core.exceptions import PermissionDenied
from django.http import JsonResponse
from django.views.decorators.csrf import csrf_exempt
from django.views.decorators.http import require_POST

from staff.lib.forms.errors import general_error
from staff.person.models.person import Staff
from staff.rfid.constants import STATE, REASON


@csrf_exempt
@require_POST
def deactivate(request, login):
    if not (request.user.get_profile().login == login or request.user.has_perm('person.can_deactivate_badge')):
        raise PermissionDenied("Not enough rights to deactivate a badge of {login}")

    try:
        person = Staff.objects.get(login=login)
    except Staff.DoesNotExist:
        return JsonResponse(general_error(f'There is no login {login}'), status=404)

    badges = person.badges.filter(state=STATE.ACTIVE)
    if not badges:
        return JsonResponse(general_error(f'There is no active badge for {login}'), status=404)
    for badge in badges:
        # В идеале нужен LOST. Но юзаем INACTIVE для одинакового поведения с
        # rfid.controllers.badge.BadgeController.deactivate()
        badge.state = STATE.INACTIVE
        badge.reason = REASON.INACTIVE
        badge.changed_by = request.user.staff
        badge.save()
    return JsonResponse(data={})
