from django.views.decorators.http import require_http_methods

from staff.person.models import Bicycle

from staff.lib.decorators import (
    responding_json,
    use_request_lang,
    available_for_external,
)
from ..permissions.utils import observer_has_perm


@require_http_methods(['GET', 'POST'])
@available_for_external
@responding_json
@observer_has_perm('bicycles')
@use_request_lang
def bicycles(request, login):
    result = list(
        Bicycle.objects
        .values('plate', 'description')
        .filter(owner__login=login)
        .order_by('position')
    )
    if result:
        return {'target': {'bicycles': result}}
    return {}
