import logging

from django.utils.html import escape
from django.views.decorators.http import require_http_methods
from django.core.exceptions import MultipleObjectsReturned, ObjectDoesNotExist

from staff.lib.decorators import (
    responding_json,
    use_request_lang,
    available_for_external,
)
from staff.innerhire.models import Candidate

from ..permissions.utils import observer_has_perm


logger = logging.getLogger('staff.person_profile.candidate_info')


@require_http_methods(['GET', 'POST'])
@available_for_external
@responding_json
@observer_has_perm('candidate_info')
@use_request_lang
def candidate_info(request, login):
    try:
        return {'target': {'candidate_info': escape(
            Candidate.objects
            .values_list('description_source', flat=True)
            .get(person__login=login, date_close=None)
        )}}
    except ObjectDoesNotExist:
        pass
    except MultipleObjectsReturned as e:
        logger.warning(e)

    return {}
