from django.views.decorators.http import require_http_methods

from staff.person.models import StaffCar

from staff.lib.decorators import (
    responding_json,
    use_request_lang,
    available_for_external,
)
from staff.person_profile.permissions.utils import observer_has_perm


@require_http_methods(['GET', 'POST'])
@available_for_external
@responding_json
@observer_has_perm('cars')
@use_request_lang
def cars(request, login):
    result = list(
        StaffCar.objects
        .active()
        .values('model', 'plate')
        .filter(staff__login=login, intranet_status=1)
        .order_by('position')
    )
    if result:
        return {'target': {'cars': result}}
    return {}
