from django.views.decorators.http import require_http_methods

from staff.lib.decorators import responding_json
from staff.person.passport.external import ExtPassport, login_has_sid_669, login_has_sid_668, try_to_get_actual_login
from staff.verification.models import ExternalLogin


@responding_json
@require_http_methods(['GET'])
def ext_passport(request, login):
    try:
        external_login = ExternalLogin.objects.get(person__login=login, status_active=True)
    except ExternalLogin.DoesNotExist:
        return {'error': 'there is no external logins known for staff'}, 404

    if external_login.person.login_passport is None:
        return {'message': 'An active external login exists, but person has no login_passport'}

    ext_passport = ExtPassport(external_login.person.login_passport, login)
    ext_login_actually_linked_to_internal_through_sid669 = try_to_get_actual_login(login)

    problems = []

    if not external_login.ext_passport_synced:
        problems.append('Staff not synced with passport')

    if not ext_passport.sid_668 and login_has_sid_668(external_login):
        problems.append('sid668 should be active on external passport but absent')

    if not ext_passport.sid_669 and login_has_sid_669(external_login):
        problems.append('sid669 should be active on external passport but absent')

        if ext_login_actually_linked_to_internal_through_sid669:
            problems.append(
                f'external login `{ext_login_actually_linked_to_internal_through_sid669}` '
                f'already uses internal login `{login}` through sid669'
            )

    if external_login.person.is_dismissed and (ext_passport.sid_668 or ext_passport.sid_669):
        problems.append('dismissed person must not have active sid668 or sid669')

    return {
        'staff_login': login,
        'is_dismissed': external_login.person.is_dismissed,
        'external_login_known_for_staff': external_login.person.login_passport,
        'sid668': ext_passport.sid_668,
        'sid669': ext_passport.sid_669,
        'ext_passport_synced': external_login.ext_passport_synced,
        'ext_login_which_uses_internal_login_on_sid669': ext_login_actually_linked_to_internal_through_sid669,
        'problems': problems,
    }
