from django.views.decorators.http import require_http_methods

from staff.lib.decorators import (
    responding_json,
    use_request_lang,
    available_for_external,
)
from staff.lib.forms.errors import default_error

from ..controllers import gpg_key as ctl
from ..permissions.utils import observer_has_perm


@available_for_external
@responding_json
@require_http_methods(['GET', 'POST'])
@observer_has_perm('gpg_keys')
@use_request_lang
def gpg_keys(request, login):
    try:
        result = list(ctl.get_initial(login))
    except ctl.GPGKeyError:
        return default_error(), 500

    if result:
        return {'target': {'gpg_keys': result}}
    return {}
