from django.views.decorators.http import require_http_methods

from staff.lib.decorators import (
    responding_json,
    use_request_lang,
    available_for_external,
)
from staff.user_settings.objects import PersonSettings


@available_for_external
@responding_json
@require_http_methods(['GET', 'POST'])
@use_request_lang
def view(request, login):
    observer = request.user.get_profile()
    return {'is_calendar_vertical': PersonSettings(observer.id)['is_calendar_vertical']}
