from django.views.decorators.http import require_http_methods

from staff.lib.decorators import (
    responding_json,
    use_request_lang,
    available_for_external,
)
from staff.lib.forms.errors import default_error

from ..permissions.utils import observer_has_perm
from ..controllers import phones as ctl


@available_for_external
@responding_json
@require_http_methods(['GET', 'POST'])
@observer_has_perm('phones')
@use_request_lang
def phones(request, login):
    try:
        result = ctl.PhonesCtl(
            target_login=login,
            permissions_ctl=request.permissions_ctl,
        ).get_phones()
        if result:
            return {'target': {'phones': result}}
        return {}
    except ctl.PhonesError:
        return default_error(), 500
