from django.views.decorators.http import require_GET
from staff.person.models import Staff, StaffExtraFields

from staff.person_avatar.controllers import PersonAvatarCollection
from staff.lib.decorators import (
    responding_json,
    use_request_lang,
    available_for_external,
)
from ..permissions.utils import observer_has_perm


def get_photos(owner):
    return [
        {
            'avatar_id': a.id,
            'is_avatar': a.metadata.is_avatar,
            'is_main': a.metadata.is_main,
        } for a in PersonAvatarCollection(owner=owner)
    ]


@require_GET
@available_for_external
@responding_json
@observer_has_perm('photos')
@use_request_lang
def photos(request, login):
    result = []
    try:
        owner = Staff.objects.get(login=login)
        if not owner.is_dismissed or owner.extra.staff_agreement:
            result = get_photos(owner)
    except (Staff.DoesNotExist, StaffExtraFields.DoesNotExist):
        pass

    return {'target': {'photos': result}}
