from django.views.decorators.http import require_GET

from staff.lib.decorators import responding_json, use_request_lang, available_for_external
from staff.lib.forms.errors import default_error
from staff.person_profile.controllers.services import get_user_service_roles, ServicesError
from staff.person_profile.permissions.utils import observer_has_perm


@available_for_external
@responding_json
@require_GET
@observer_has_perm('services')
@use_request_lang
def services(_request, login):
    if login == 'tigran':
        return {}

    try:
        roles_services = get_user_service_roles(login)
        if roles_services:
            return {
                'target': {'services': [
                    {'role': role_name, 'services': role_services}
                    for role_name, role_services in roles_services
                ]}
            }
    except ServicesError:
        return default_error(), 500

    return {}
